definition module deltaPrint

//	Clean 0.8 I/O library module. This module is not supported under Unix.

//	********************************************************************************
//	deltaPrint specifies general printing functions.
//	Related functions and modules:
//	-	getResolution (deltaPicture)
//	-	resizeBitmap  (deltaBitmap)
//	-	deltaPrintText to print text.
//	********************************************************************************

from	deltaPicture	import	Picture, Point, DrawFunction, Rectangle
from	StdOverloaded	import	==
from	osPrint08		import	PrintSetup, JobInfo, PrintInfo, Alternative, 
								Cancelled, StartedPrinting, PrintEnvironments,
								PState
from	ioTypes			import	UpdateFunction, UpdateArea, IOState
from	StdFile			import	Files

::	PageDimensions
	=	{	page		:: !(!Int,!Int)	// width and height of the drawable area
										// of the page in pixels.
		,	margins		:: !Rectangle	// This field contains information about the
										// size of the margins on a sheet in pixels.
										// Drawing can't occur within these margins.
										// The margin Rectangle is bigger than the
										// page size. 
										// If margins=((left,top),(right,bot)), then
										// left<=0 && top<=0 && 
										// right>=fst page && bot>=snd page
		,	resolution	:: !(!Int,!Int)	// horizontal and vertical printer
										// resolution in dpi
		}

class PrintSetupEnvironments env
  where
	defaultPrintSetup	::	!*env -> (!PrintSetup, !*env)
		// returns a default print setup 
	printSetupDialog	::	!PrintSetup !*env -> (!PrintSetup, !*env)
		// lets the user choose a print setup via the print setup dialog
		
instance PrintSetupEnvironments World, IOState s, PState s
// The PState instance is the one that can handle update events on all platforms

getPageDimensions	::	!PrintSetup	!Bool->	PageDimensions
instance == PageDimensions

fwritePrintSetup	::	!PrintSetup !*File -> *File
//	writes PrintSetup to file (text or data)

freadPrintSetup		::	!*File !*env -> (!Bool, !PrintSetup, !*File, !*env)	
					|	PrintSetupEnvironments env
//	reads PrintSetup from File (text or data). If resulting Boolean is True:success,
//	otherwise the default PrintSetup is returned

printSetupTypical	::	Bool
//	a platform dependent value that indicates whether a print setup dialog box is
//	typical for this platform.

print	::	!Bool !Bool
			.(PrintInfo !*Picture -> ([DrawFunction],!*Picture))
			!PrintSetup !*printEnv
		->	(!PrintSetup,!*printEnv)
		|	PrintEnvironments printEnv

/*	print doDialog emulateScreen pages printSetup env
	sends output to the printer and returns the used print setup, which can differ
	from the input print setup
	doDialog:
		if True a dialog will pop up that lets the user choose all printing options,
		otherwise printing will happen in the default way.
	emulateScreen:
		if True, the printing routine will emulate the resolution of the screen. 
		That means that a pixel on paper has the same dimension as on screen. 
		Otherwise, the used resolution will be the printer resolution, with the 
		effect that coordinates get much "tighter". 
	pages:
		this function should calculate a list of functions, each function 
		representing one page to be printed. Each of these drawing functions is
		applied	to an initial printer Picture.
	env:
		a PrintEnvironment is either the PState or the Files system.  
*/

printUpdateFunction 
		:: 	!Bool (UpdateFunction *s) [Rectangle] *s 
			!PrintSetup !*printEnv 
		-> 	((*s, !PrintSetup), !*printEnv)
		| PrintEnvironments printEnv

/*	printUpdateFunction doDialog update area printSetup env
	sends the content of the update function of a given area to the printer:
	doDialog:
		identical to print.
	update:
		the window update function
	area:
		the area to be sent to the printer. If a rectangle of this area does not
		fit on one sheet, it will be distributed on several sheets. 
	printSetup,env,result value:
		identical to print.
*/

printPagePerPage ::	!Bool !Bool 
					.x
					.(.x -> .(PrintInfo -> .(*Picture -> ((.Bool,Point),(.state,*Picture)))))
					((.state,*Picture) -> ((.Bool,Point),(.state,*Picture)))
					!PrintSetup !*printEnv 
				-> 	(Alternative .x .state,!*printEnv)
		        | PrintEnvironments printEnv

/*	printPagePerPage doDialog emulateScreen x prepare pages printSetup env
	sends output to the printer.
	This function can be used more efficiently than print. The major difference is 
	that the pages function is a state transition function instead of a page list 
	producing function. Each page transition function generates one page for the 
	printer. An additional feature of printPagePerPage is that it is possible to
	set the origin of the printer Pictures.

	doDialog:
		identical to print. 
	emulateScreen:
		identical to print.
	x:
		this value is passed to the prepare function.
	prepare:
		this function calculates the initial page print state. 
		Iff there are no pages to print, the return Boolean must be True.
		The returned Point is the Origin of the first printer Picture.
	pages:
		this state transition function produces the printed pages. 
		The state argument consists of the state information and an initial printer
		Picture which Origin has been set by the previous return Point value. 
		If there are no more pages to print, the return Boolean must be True. In 
		that case the result of printPagePerPage is (StartedPrinting state),
		with state the current state value. If printing should continue, the
		return Boolean is False.
		The returned Point is the Origin of the next printer Picture. 
	printSetup, env:
		identical to print.
	
	If printing is cancelled via the print dialog, then (Cancelled x) will be
	returned, otherwise (StartedPrinting ...)
*/
 
instance PrintEnvironments World
// other instances are the Files subworld and the PState (see osPrint08.dcl)

/*	The 0.8 IO-library functions "FontCharWidth(s)","FontString/Width(s)" and "FontMetrics" have no
	"Picture" parameter. They will return values, that are only applicable to screen pictures or
	printer pictures, that emulate the screen resolution. The functions "PictureCharWidth",
	"PictureStringWidth" and "PictureFontmetrics" don't show that disadvantage.
 */
